IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CRIACAO_CONTRATO_VERBA]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CRIACAO_CONTRATO_VERBA]
GO

--EXEC P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CRIACAO_CONTRATO_VERBA 1, 983, 199260
CREATE PROCEDURE 
	P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CRIACAO_CONTRATO_VERBA (@CD_EMP INT, @CD_CTR_GRUPO INT, @CD_FORN INT)
AS

SET NOCOUNT ON;
DECLARE @CD_FND_VERBA INT
DECLARE @CD_FND_VERBA_USO INT
DECLARE @CD_DOC INT
DECLARE @CD_FILIAL_FAT INT
DECLARE @CD_USU_NEGOCIADOR INT

DECLARE @DT_INI_APURACAO DATETIME
DECLARE @DT_FIM_APURACAO DATETIME

CREATE TABLE #RsVerba (CD_CTR_GRUPO INT,
					   VLR_RESSARCIMENTO MONEY,	
					   CD_DOC INT,
					   CD_FILIAL_FAT INT,
					   CD_USU_NEGOCIADOR INT,
					   CD_CTR INT,
					   CD_FND_VERBA INT)

CREATE TABLE #RsVerbaUso (CD_CTR_GRUPO INT,
					   CD_PROD INT,	
					   VLR_RESSARCIMENTO MONEY,
					   QT_IT MONEY)


DECLARE @VLR_RESSARCIMENTO MONEY


SELECT
	@DT_INI_APURACAO = DT_INI,
	@DT_FIM_APURACAO = DT_FIM
FROM
	CG_FND_VERBA_NOTA_CREDITO_GRUPO
WHERE
	CD_CTR_GRUPO = @CD_CTR_GRUPO


--Buscando valores e contratos de kits para fechamento
INSERT INTO 
	#RsVerba (CD_CTR_GRUPO,VLR_RESSARCIMENTO,CD_DOC,CD_FILIAL_FAT,CD_USU_NEGOCIADOR,CD_CTR,CD_FND_VERBA)
SELECT
	CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO,
	SUM(CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS.VLR_RESSARCIMENTO),
	CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_DOC,
	CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_FILIAL_FAT,
	CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_USU_NEGOCIADOR,
	COALESCE(CG_FND_VERBA_NOTA_CREDITO_GRUPO_FECHAMENTO.CD_CTR, -1) AS CD_CTR,
	COALESCE(CG_FND_VERBA_NOTA_CREDITO_GRUPO_CG_FND_VERBA.CD_FND_VERBA, -1) AS CD_FND_VERBA
FROM
	CG_FND_VERBA_NOTA_CREDITO_GRUPO 
	INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS ON
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS.CD_CTR_GRUPO
	LEFT OUTER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO_FECHAMENTO ON
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = CG_FND_VERBA_NOTA_CREDITO_GRUPO_FECHAMENTO.CD_CTR_GRUPO
	LEFT OUTER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO_CG_FND_VERBA ON
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_FECHAMENTO.CD_CTR = CG_FND_VERBA_NOTA_CREDITO_GRUPO_CG_FND_VERBA.CD_CTR
WHERE
	CG_FND_VERBA_NOTA_CREDITO_GRUPO.FLAG_FECHAR_VERBA=1
	AND CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = @CD_CTR_GRUPO
GROUP BY
	CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO,
	CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_DOC,
	CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_FILIAL_FAT,
	CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_USU_NEGOCIADOR,
	COALESCE(CG_FND_VERBA_NOTA_CREDITO_GRUPO_FECHAMENTO.CD_CTR, -1),
	COALESCE(CG_FND_VERBA_NOTA_CREDITO_GRUPO_CG_FND_VERBA.CD_FND_VERBA, -1)


IF EXISTS(SELECT TOP 1 CD_CTR_GRUPO FROM #RsVerba WHERE CD_FND_VERBA = -1)
BEGIN

	--Gerando valor de ressarmento final
	SET @CD_DOC = ISNULL((SELECT
							SUM(V.CD_DOC)
						FROM 
							#RsVerba V),0)
	SET @CD_FILIAL_FAT = ISNULL((SELECT
									SUM(V.CD_FILIAL_FAT)
								FROM 
									#RsVerba V),0)

	SET @CD_USU_NEGOCIADOR = ISNULL((SELECT
										SUM(V.CD_USU_NEGOCIADOR)
									FROM 
										#RsVerba V),0)

	SET @VLR_RESSARCIMENTO = ISNULL((SELECT
										SUM(V.VLR_RESSARCIMENTO)
									FROM 
										#RsVerba V),0)


	--Controle de fechamento do contrato de kit
	INSERT INTO CG_FND_VERBA_NOTA_CREDITO_GRUPO_FECHAMENTO (CD_CTR_GRUPO,
															  DT_FECHAMENTO,
															  DT_CAD,
															  CD_USU,
															  VLR_FECHAMENTO)
	SELECT
		CD_CTR_GRUPO,
		CONVERT(CHAR(10),GETDATE(),112) AS DT_LANCTO,
		CONVERT(CHAR(10),GETDATE(),112) AS DT_LANCTO,
		1 AS CD_USU,
		VLR_RESSARCIMENTO	
	FROM 
		#RsVerba

	--Proximo codigo de contrato de verba
	SET @CD_FND_VERBA= ISNULL((SELECT
									MAX(CD_FND_VERBA)
							   FROM
									CG_FND_VERBA
							   WHERE
									CD_EMP=@CD_EMP),0) + 1

	--Contrato de verba
	INSERT INTO CG_FND_VERBA
		(CD_EMP,
		CD_FND_VERBA,
		CD_FORN,
		HIST_LANC,
		VLR_LANC,
		VLR_RECB,
		VLR_GLOSA,
		TP_LANC,
		STATUS,
		ORIG_LANC,
		DT_LANCTO,
		DT_VENCTO,
		DT_ACORDO,
		DT_RECEB,
		DT_CAD,
		DT_ULT_ALT,
		CD_USU,
		CD_USU_NEGOCIADOR,
		DT_INI_APURACAO,
		DT_FIM_APURACAO,
		CD_FND_VERBA_TIPO,
		FLAG_NAO_PARAMETRIZAR_USO_CAD,
		CD_DOC,
		CD_FILIAL_FAT,
		DIA_VENCTO,
		FLAG_FORN_VINCULADO,
		TP_ATRIB,
		INFO_ADD,
		NR_PARC)

	SELECT
		@CD_EMP AS CD_EMP,
		@CD_FND_VERBA AS CD_FND_VERBA,
		@CD_FORN AS CD_FORN,
		CONCAT('CONTRATO DE VERBA REFERENTE KITS: ', @CD_CTR_GRUPO),
		@VLR_RESSARCIMENTO AS VLR_RESSARCIMENTO,
		0 AS VLR_RECB,
		0 AS VLR_GLOSA,
		0 AS TP_LANC,
		0 AS STATUS,
		0 AS ORIG_LANC,
		CONVERT(CHAR(10),GETDATE(),112) AS DT_LANCTO,
		CONVERT(CHAR(10),GETDATE(),112) AS DT_VENCTO,
		CONVERT(CHAR(10),GETDATE(),112) AS DT_ACORDO,
		CONVERT(CHAR(10),GETDATE(),112) AS DT_RECEB,
		CONVERT(CHAR(10),GETDATE(),112) AS DT_CAD,
		NULL AS DT_ULT_ALT,
		@CD_USU_NEGOCIADOR AS CD_USU,
		@CD_USU_NEGOCIADOR AS CD_USU_NEGOCIADOR,
		CONVERT(CHAR(10),GETDATE(),112) AS DT_INI_APURACAO,
		CONVERT(CHAR(10),GETDATE(),112) AS DT_FIM_APURACAO,
		1 AS CD_FND_VERBA_TIPO,
		0 AS FLAG_NAO_PARAMETRIZAR_USO_CAD,
		@CD_DOC AS CD_DOC,
		@CD_FILIAL_FAT AS CD_FILIAL_FAT,
		0 AS DIA_VENCTO,
		0 AS FLAG_FORN_VINCULADO,
		0 AS TP_ATRIB,
		'' AS INFO_ADD,
		0 AS NR_PARC 


	INSERT INTO 
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_CG_FND_VERBA (CD_CTR, CD_EMP, CD_FND_VERBA)
	SELECT
		IDENT_CURRENT('CG_FND_VERBA_NOTA_CREDITO_GRUPO_FECHAMENTO'),
		@CD_EMP,
		@CD_FND_VERBA


	INSERT INTO 
		CG_FND_VERBA_LIB (CD_EMP, CD_FND_VERBA, CD_USU_FORN, CD_USU, DT_LIB, HR_LIB)
	SELECT
		@CD_EMP,
		@CD_FND_VERBA,
		0 AS CD_USU_FORN,
		1 AS CD_USU,
		GETDATE(),
		GETDATE()


	SET @CD_FND_VERBA_USO = ISNULL((SELECT
									MAX(CD_FND_VERBA_USO)
							   FROM
									CG_FND_VERBA_USO
							   WHERE
									CD_EMP=@CD_EMP),0) + 1

	INSERT INTO
		CG_FND_VERBA_USO (
			CD_EMP
			,CD_FND_VERBA_USO
			,DS_FND_VERBA_USO
			,CD_FORN
			,TP_LANC
			,STATUS
			,DT_LANCTO
			,DT_CAD
			,DT_ULT_ALT
			,CD_USU
			,CD_USU_NEGOCIADOR
			,DT_INI_APURACAO
			,DT_FIM_APURACAO)

	SELECT
		@CD_EMP AS CD_EMP,
		@CD_FND_VERBA_USO,
		CONCAT('USO DE VERBA REFERENTE KITS DE PROMOCAO: ', @CD_CTR_GRUPO),
		@CD_FORN,
		0 AS TP_LANC,
		0 AS STATUS,
		CONVERT(CHAR(10),GETDATE(),112) AS DT_LANCTO,
		CONVERT(CHAR(10),GETDATE(),112) AS DT_CAD,
		NULL AS DT_ULT_ALT,
		@CD_USU_NEGOCIADOR AS CD_USU,
		@CD_USU_NEGOCIADOR AS CD_USU_NEGOCIADOR,
		@DT_INI_APURACAO AS DT_INI_APURACAO,
		@DT_FIM_APURACAO AS DT_FIM_APURACAO;

	INSERT INTO
		CG_FND_VERBA_USO_PROD (
			CD_EMP
			,CD_FND_VERBA_USO
			,CD_PROD
			,VLR_IT
			,LIMITE_VERBA
			,DT_CAD
			,DT_ULT_ALT
			,CD_USU
			,FLAG_PROD_ADD)

	SELECT
		@CD_EMP AS CD_EMP,
		@CD_FND_VERBA_USO,
		GRUPO.CD_PROD,
		GRUPO.VLR_RESSARCIMENTO,
		0 AS LIMITE_VERBA,
		CONVERT(CHAR(10),GETDATE(),112) AS DT_CAD,
		NULL AS DT_ULT_ALT,
		@CD_USU_NEGOCIADOR AS CD_USU,
		0 AS FLAG_PROD_ADD
	FROM
		(SELECT
			CG.CD_CTR_GRUPO,
			ARV.CD_PROD,
			CG2.VLR_RESSARCIMENTO
		FROM
			CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA CG
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				CG.CD_EMP = ARV.CD_EMP
				AND CG.CD_ARV_MERC_CATEG = ARV.CD_ARV_MERC_CATEG
			INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO CG2 ON
				CG.CD_CTR_GRUPO = CG2.CD_CTR_GRUPO

		UNION
	
		SELECT
			CG.CD_CTR_GRUPO,
			ARV.CD_PROD,
			CG2.VLR_RESSARCIMENTO
		FROM
			CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_PROD_FABRIC CG
			INNER JOIN EST_PROD ARV ON
				CG.CD_FABRIC = ARV.CD_FABRIC
			INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO CG2 ON
				CG.CD_CTR_GRUPO = CG2.CD_CTR_GRUPO
			
		UNION

		SELECT
			CG.CD_CTR_GRUPO,
			ARV.CD_PROD,
			CG2.VLR_RESSARCIMENTO
		FROM
			CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_FAMILIA CG
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				CG.CD_EMP = ARV.CD_EMP
				AND CG.CD_ARV_MERC_FAMILIA = ARV.CD_ARV_MERC_FAMILIA
			INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO CG2 ON
				CG.CD_CTR_GRUPO = CG2.CD_CTR_GRUPO

		UNION

		SELECT
			CG.CD_CTR_GRUPO,
			ARV.CD_PROD,
			CG2.VLR_RESSARCIMENTO
		FROM
			CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_LINHA CG
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				CG.CD_EMP = ARV.CD_EMP
				AND CG.CD_ARV_MERC_LINHA = ARV.CD_ARV_MERC_LINHA
			INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO CG2 ON
				CG.CD_CTR_GRUPO = CG2.CD_CTR_GRUPO

		UNION

		SELECT
			CG.CD_CTR_GRUPO,
			ARV.CD_PROD,
			CG2.VLR_RESSARCIMENTO
		FROM
			CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_MC CG
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				CG.CD_EMP = ARV.CD_EMP
				AND CG.CD_MC = ARV.CD_MC
			INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO CG2 ON
				CG.CD_CTR_GRUPO = CG2.CD_CTR_GRUPO

		UNION

		SELECT
			CG.CD_CTR_GRUPO,
			CG.CD_PROD,
			CG2.VLR_RESSARCIMENTO
		FROM
			CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_PROD CG
			INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO CG2 ON
				CG.CD_CTR_GRUPO = CG2.CD_CTR_GRUPO) GRUPO

		INNER JOIN #RsVerba VERBA ON
			GRUPO.CD_CTR_GRUPO = VERBA.CD_CTR_GRUPO


	INSERT INTO
		CG_FND_VERBA_USO_CG_FND_VERBA (CD_EMP, CD_FND_VERBA_USO, CD_FND_VERBA)
	VALUES
		(@CD_EMP, @CD_FND_VERBA_USO, @CD_FND_VERBA)
END

--QUANDO J EXISTE O CONTRATO CRIADO, ATUALIZA O VALOR DO RESSARCIMENTO DO CONTRATO J EXISTENTE
ELSE BEGIN
	UPDATE
		C
	SET
		C.VLR_LANC = V.VLR_RESSARCIMENTO
	FROM
		CG_FND_VERBA C
		INNER JOIN #RsVerba V ON
			C.CD_FND_VERBA = V.CD_FND_VERBA;

	SELECT
		@CD_FND_VERBA = C.CD_FND_VERBA,
		@CD_FND_VERBA_USO = U.CD_FND_VERBA_USO,
		@CD_USU_NEGOCIADOR = V.CD_USU_NEGOCIADOR
	FROM
		CG_FND_VERBA C
		INNER JOIN #RsVerba V ON
			C.CD_FND_VERBA = V.CD_FND_VERBA
		INNER JOIN CG_FND_VERBA_USO_CG_FND_VERBA U ON
			C.CD_FND_VERBA = U.CD_FND_VERBA;


	PRINT CONCAT('CONTRATO JA EXISTENTE: Contrato: ', @CD_FND_VERBA, ' - Uso: ', @CD_FND_VERBA_USO);
	
END

--ATRIBUINDO A MARGEM NA VENDA
DECLARE @CD_FILIAL_AUX			INT
DECLARE @CD_VD_AUX				INT
DECLARE @CD_IT_AUX				INT
DECLARE @QT_IT_VENDA_AUX		MONEY
DECLARE @CD_FND_VERBA_USO_AUX	INT
DECLARE @CD_PROD_AUX			INT
DECLARE @VLR_RESSARCIMENTO_AUX	MONEY
DECLARE @QT_IT_AUX				MONEY

DECLARE @CD_VD_AUX_AUX			INT
DECLARE @QTDE_IT_AUX			MONEY
DECLARE @CD_FND_VERBA_SAQUE		INT
DECLARE @VLR_SLD_ANT			MONEY
DECLARE @CD_RECEITA				INT


INSERT INTO
	#RsVerbaUso
SELECT
	CG.CD_CTR_GRUPO,
	ARV.CD_PROD,
	CG2.VLR_RESSARCIMENTO,
	CG.QT_IT
FROM
	CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA CG
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
		CG.CD_EMP = ARV.CD_EMP
		AND CG.CD_ARV_MERC_CATEG = ARV.CD_ARV_MERC_CATEG
	INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO CG2 ON
		CG.CD_CTR_GRUPO = CG2.CD_CTR_GRUPO
WHERE
	CG.CD_CTR_GRUPO = @CD_CTR_GRUPO

UNION
	
SELECT
	CG.CD_CTR_GRUPO,
	ARV.CD_PROD,
	CG2.VLR_RESSARCIMENTO,
	CG.QT_IT
FROM
	CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_PROD_FABRIC CG
	INNER JOIN EST_PROD ARV ON
		CG.CD_FABRIC = ARV.CD_FABRIC
	INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO CG2 ON
		CG.CD_CTR_GRUPO = CG2.CD_CTR_GRUPO
WHERE
	CG.CD_CTR_GRUPO = @CD_CTR_GRUPO
			
UNION 

SELECT
	CG.CD_CTR_GRUPO,
	ARV.CD_PROD,
	CG2.VLR_RESSARCIMENTO,
	CG.QT_IT
FROM
	CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_FAMILIA CG
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
		CG.CD_EMP = ARV.CD_EMP
		AND CG.CD_ARV_MERC_FAMILIA = ARV.CD_ARV_MERC_FAMILIA
	INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO CG2 ON
		CG.CD_CTR_GRUPO = CG2.CD_CTR_GRUPO
WHERE
	CG.CD_CTR_GRUPO = @CD_CTR_GRUPO

UNION

SELECT
	CG.CD_CTR_GRUPO,
	ARV.CD_PROD,
	CG2.VLR_RESSARCIMENTO,
	CG.QT_IT
FROM
	CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_LINHA CG
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
		CG.CD_EMP = ARV.CD_EMP
		AND CG.CD_ARV_MERC_LINHA = ARV.CD_ARV_MERC_LINHA
	INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO CG2 ON
		CG.CD_CTR_GRUPO = CG2.CD_CTR_GRUPO
WHERE
	CG.CD_CTR_GRUPO = @CD_CTR_GRUPO

UNION


SELECT
	CG.CD_CTR_GRUPO,
	ARV.CD_PROD,
	CG2.VLR_RESSARCIMENTO,
	CG.QT_IT
FROM
	CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_MC CG
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
		CG.CD_EMP = ARV.CD_EMP
		AND CG.CD_MC = ARV.CD_MC
	INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO CG2 ON
		CG.CD_CTR_GRUPO = CG2.CD_CTR_GRUPO
WHERE
	CG.CD_CTR_GRUPO = @CD_CTR_GRUPO

UNION

SELECT
	CG.CD_CTR_GRUPO,
	CG.CD_PROD,
	CG2.VLR_RESSARCIMENTO,
	CG.QT_IT
FROM
	CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_PROD CG
	INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO CG2 ON
		CG.CD_CTR_GRUPO = CG2.CD_CTR_GRUPO
WHERE
	CG.CD_CTR_GRUPO = @CD_CTR_GRUPO


DECLARE CURSOR_MARGEM CURSOR
FOR
	SELECT
		PDV_VD_IT.CD_FILIAL,
		PDV_VD_IT.CD_VD,
		PDV_VD_IT.CD_IT,
		PDV_VD_IT.QT_IT AS QT_IT_VENDA,
		CG_FND_VERBA_USO_PROD.CD_FND_VERBA_USO,
		PDV_VD_IT.CD_PROD,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS.VLR_RESSARCIMENTO,
		GRUPO.QT_IT
	FROM
		#RsVerba VERBA
		INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS ON
			VERBA.CD_CTR_GRUPO = CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS.CD_CTR_GRUPO

		INNER JOIN PDV_VD_IT ON
			CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS.CD_EMP = PDV_VD_IT.CD_EMP
			AND CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS.CD_FILIAL = PDV_VD_IT.CD_FILIAL
			AND CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS.CD_VD = PDV_VD_IT.CD_VD

		INNER JOIN CG_FND_VERBA_USO_PROD ON
			PDV_VD_IT.CD_EMP = CG_FND_VERBA_USO_PROD.CD_EMP
			AND PDV_VD_IT.CD_PROD = CG_FND_VERBA_USO_PROD.CD_PROD
			AND CG_FND_VERBA_USO_PROD.CD_FND_VERBA_USO = @CD_FND_VERBA_USO

		INNER JOIN CG_FND_VERBA_USO_CG_FND_VERBA ON
			CG_FND_VERBA_USO_PROD.CD_EMP = CG_FND_VERBA_USO_CG_FND_VERBA.CD_EMP
			AND CG_FND_VERBA_USO_PROD.CD_FND_VERBA_USO = CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA_USO

		INNER JOIN UFD_CG_FND_VERBA_RETORNA_VLR (@CD_EMP, @CD_FND_VERBA) VLR ON
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_EMP = VLR.CD_EMP
			AND CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA = VLR.CD_FND_VERBA

		INNER JOIN #RsVerbaUso GRUPO ON
			VERBA.CD_CTR_GRUPO = GRUPO.CD_CTR_GRUPO
			AND CG_FND_VERBA_USO_PROD.CD_PROD = GRUPO.CD_PROD
	WHERE
		CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS.CD_EMP = @CD_EMP
		AND VLR.VLR_SALDO > 0
		AND NOT EXISTS (
			SELECT
				*
			FROM
				CG_FND_VERBA_SAQUE_CG_FND_VERBA_USO_PDV_VD_IT
			WHERE
				PDV_VD_IT.CD_EMP = CG_FND_VERBA_SAQUE_CG_FND_VERBA_USO_PDV_VD_IT.CD_EMP
				AND PDV_VD_IT.CD_FILIAL = CG_FND_VERBA_SAQUE_CG_FND_VERBA_USO_PDV_VD_IT.CD_FILIAL
				AND PDV_VD_IT.CD_VD = CG_FND_VERBA_SAQUE_CG_FND_VERBA_USO_PDV_VD_IT.CD_VD
				AND CG_FND_VERBA_SAQUE_CG_FND_VERBA_USO_PDV_VD_IT.CD_FND_VERBA = @CD_FND_VERBA)
		AND NOT EXISTS (
			SELECT
				*
			FROM
				CG_FND_VERBA_USO_PDV_VD_IT
			WHERE
				PDV_VD_IT.CD_EMP = CG_FND_VERBA_USO_PDV_VD_IT.CD_EMP
				AND PDV_VD_IT.CD_FILIAL = CG_FND_VERBA_USO_PDV_VD_IT.CD_FILIAL
				AND PDV_VD_IT.CD_VD = CG_FND_VERBA_USO_PDV_VD_IT.CD_VD
				AND CG_FND_VERBA_USO_PDV_VD_IT.CD_FND_VERBA_USO = @CD_FND_VERBA_USO)
	ORDER BY
		PDV_VD_IT.CD_EMP ASC,
		PDV_VD_IT.CD_FILIAL ASC,
		PDV_VD_IT.CD_VD ASC,
		PDV_VD_IT.TOT_IT ASC,
		PDV_VD_IT.VLR_IT ASC,
		PDV_VD_IT.TX_DESC DESC;

OPEN CURSOR_MARGEM

FETCH NEXT FROM CURSOR_MARGEM INTO @CD_FILIAL_AUX, @CD_VD_AUX, @CD_IT_AUX, @QT_IT_VENDA_AUX ,@CD_FND_VERBA_USO_AUX, @CD_PROD_AUX, @VLR_RESSARCIMENTO_AUX, @QT_IT_AUX

SET @CD_RECEITA = 0
SELECT @CD_RECEITA = VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'CD_RECEITA_VERBA_GERENCIAL'

IF @CD_RECEITA = 0
BEGIN
	RAISERROR ('P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CRIACAO_CONTRATO_VERBA - CODIGO DA RECEITA PARA LANCAMENTO DO CONTAS A RECEBER NAO ENCONTRADO.',16, 1);
	ROLLBACK TRANSACTION;
	RETURN;
END

SET @CD_VD_AUX_AUX = 0;

WHILE @@FETCH_STATUS = 0
BEGIN
	
	IF @CD_VD_AUX_AUX <> @CD_VD_AUX
	BEGIN
		SET @QTDE_IT_AUX = @QT_IT_AUX;
		SET @CD_VD_AUX_AUX = @CD_VD_AUX;
	END

	IF @QTDE_IT_AUX > 0
	BEGIN
		SET @CD_FND_VERBA_SAQUE = COALESCE((SELECT MAX(CD_FND_VERBA_SAQUE) FROM CG_FND_VERBA_SAQUE WHERE CD_EMP = @CD_EMP AND CD_FND_VERBA = @CD_FND_VERBA), 0) + 1
		SET @VLR_SLD_ANT = COALESCE((SELECT SUM(VLR_SAQUE) FROM CG_FND_VERBA_SAQUE WHERE CD_EMP = @CD_EMP AND CD_FND_VERBA = @CD_FND_VERBA), 0)


		INSERT INTO 
			CG_FND_VERBA_USO_PDV_VD_IT (CD_EMP, CD_FND_VERBA_USO, CD_FILIAL, CD_VD, CD_IT, VLR_USO, CD_PROD)
		VALUES (@CD_EMP, @CD_FND_VERBA_USO, @CD_FILIAL_AUX, @CD_VD_AUX, @CD_IT_AUX, @VLR_RESSARCIMENTO_AUX, @CD_PROD_AUX)


		INSERT INTO
			CG_FND_VERBA_SAQUE (CD_EMP, CD_FND_VERBA, CD_FND_VERBA_SAQUE, CD_DESP_REC, 
								HIST_SAQ, DT_SAQUE, STATUS, VLR_SAQUE, SALDO_ANT, DT_CAD, CD_USU)
		VALUES
			(@CD_EMP, @CD_FND_VERBA, @CD_FND_VERBA_SAQUE, @CD_RECEITA, 
			'ALOCACAO DE VERBA NO CONTRATO: ' + CAST(@CD_FND_VERBA AS VARCHAR), CONVERT(DATE, GETDATE()), 0, @VLR_RESSARCIMENTO_AUX, @VLR_SLD_ANT, CONVERT(DATE, GETDATE()), @CD_USU_NEGOCIADOR)


		INSERT INTO
			CG_FND_VERBA_SAQUE_CG_FND_VERBA_USO_PDV_VD_IT(CD_EMP, CD_FND_VERBA_USO, CD_FILIAL, CD_VD, CD_IT, CD_FND_VERBA_SAQUE, CD_FND_VERBA)
		VALUES(@CD_EMP, @CD_FND_VERBA_USO, @CD_FILIAL_AUX, @CD_VD_AUX, @CD_IT_AUX, @CD_FND_VERBA_SAQUE, @CD_FND_VERBA)


		UPDATE
			PDV_VD_IT
		SET
			VLR_RECOMPOSICAO_MARGEM = VLR_RECOMPOSICAO_MARGEM + @VLR_RESSARCIMENTO_AUX
		WHERE
			CD_EMP = @CD_EMP
			AND CD_FILIAL = @CD_FILIAL_AUX
			AND CD_VD = @CD_VD_AUX
			AND CD_IT = @CD_IT_AUX
			

		SET @QTDE_IT_AUX = @QTDE_IT_AUX - 1;

	END


	FETCH NEXT FROM CURSOR_MARGEM INTO @CD_FILIAL_AUX, @CD_VD_AUX, @CD_IT_AUX, @QT_IT_VENDA_AUX ,@CD_FND_VERBA_USO_AUX, @CD_PROD_AUX, @VLR_RESSARCIMENTO_AUX, @QT_IT_AUX
END


CLOSE CURSOR_MARGEM
DEALLOCATE CURSOR_MARGEM

DROP TABLE #RsVerba;
